<?php
function login()
{
  if(!$this->dbo) return SERVER_ERROR;
  
  //Sprawdzenie czy zostały przekazane parametry.
  if(!isset($_POST["user"]) || !isset($_POST["haslo"])){
    return LOGIN_FAILED;
  }
  
  $user = $_POST["user"];
  $pass = $_POST["haslo"];
  
  //Sprawdzenie długości przekazanych ciągów.
  //Dla kodowania jednobajtowego
  //$userNameLength = strlen($user);
  //$userPassLength = strlen($pass);
  //Dla kodowania utf-8
  $userNameLength = strlen(utf8_decode($user));
  $userPassLength = strlen(utf8_decode($pass));
  
  if($userNameLength < 3 || $userNameLength > 20 ||
     $userPassLength < 6 || $userPassLength > 40){
    return LOGIN_FAILED;
  }

  //Zabezpieczenie znaków specjalnych w parametrach.
  $user = $this->dbo->real_escape_string($user);
  $pass = $this->dbo->real_escape_string($pass);
  
  //Wykonanie zapytania sprawdzającego poprawność danych.
  $query = "SELECT Haslo, Nazwa, Id ";
  $query .= "FROM Users WHERE Nazwa='$user'";

  if(!$result = $this->dbo->query($query)){
    //echo 'Wystąpił błąd: nieprawidłowe zapytanie...';
    return SERVER_ERROR;
  }

  //Sprawdzenie wyników zapytania.
  if($result->num_rows != 1){
    //Brak użytkownika o wskazanej nazwie lub zbyt wiele wyników.
    return LOGIN_FAILED;
  }
  else{
    $row = $result->fetch_row();
    $pass_db = $row[0];
    //Wersja bez kodowania haseł.
    //if($pass != $pass_db){
    //Wersja z kodowaniem haseł.
    if(crypt($pass, $pass_db) != $pass_db){
      return LOGIN_FAILED;
    }
    else{
      $_SESSION['zalogowany_adm'] = $row[1];
    }
    
    //Obsługa przywilejów.
    
    //Utworzenie zmiennej sesji, jeśli konieczne.
    if(!isset($_SESSION['przywileje'])){
      $_SESSION['przywileje'] = array();
    }
    
    //Zapytanie pobierające dane.
    $query = "SELECT PrzywilejId FROM Uzytkownicy_Przywileje ";
    $query .= "WHERE UserId=" . $row[2];
    
    //Zapis danych o przywilejach z zmiennej sesji.
    if($result = $this->dbo->query($query)){
       while($row = $result->fetch_row()){
         $_SESSION['przywileje'][$row[0]] = true;
       }
    }
    
    //Rezultat logowania.
    if(isset($_SESSION['przywileje'][1])){
      return LOGIN_OK;
    }
    else{
      return NO_ADMIN_RIGHTS;
    }
  }
}
?>